/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.breakpoint.property;

import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org2.eclipse.php.internal.debug.core.model.PHPConditionalBreakpoint;
import org2.eclipse.php.internal.debug.ui.PHPDebugUIMessages;

public class PHPBreakpointPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private boolean conditionEnabled;
    private Text text;
    private PHPConditionalBreakpoint breakpoint;

    public PHPBreakpointPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        this.breakpoint = (PHPConditionalBreakpoint)((Object)this.getElement().getAdapter(PHPConditionalBreakpoint.class));
        if (this.breakpoint == null) {
            PHPDebugEPLPlugin.logError("Could not adapt to PHPConditionalBreakpoint");
            return null;
        }
        this.conditionEnabled = this.breakpoint.isConditionEnabled();
        String currentCondition = this.breakpoint.getCondition();
        if (currentCondition.equals("")) {
            this.conditionEnabled = true;
        }
        Label label = new Label(parent, 64);
        label.setText(MessageFormat.format(PHPDebugUIMessages.EnterCondition_1, new Object[0]));
        GridData data = new GridData(772);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        this.text = new Text(parent, 2052);
        this.text.setLayoutData((Object)new GridData(768));
        this.text.setText(currentCondition);
        final Button checkbox = new Button(parent, 32);
        data = new GridData(768);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        checkbox.setLayoutData((Object)data);
        checkbox.setFont(parent.getFont());
        checkbox.setText(MessageFormat.format(PHPDebugUIMessages.EnableSetCondition_1, new Object[0]));
        checkbox.setSelection(this.conditionEnabled);
        this.text.setEnabled(this.conditionEnabled);
        checkbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PHPBreakpointPropertyPage.this.conditionEnabled = checkbox.getSelection();
                PHPBreakpointPropertyPage.this.text.setEnabled(PHPBreakpointPropertyPage.this.conditionEnabled);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return parent;
    }

    public boolean performOk() {
        if (this.breakpoint != null) {
            String condition = this.text.getText().trim();
            if (condition.equals("")) {
                this.conditionEnabled = false;
            }
            try {
                this.breakpoint.setConditionWithEnable(this.conditionEnabled, condition);
            }
            catch (CoreException e) {
                PHPDebugEPLPlugin.logError(e);
            }
        }
        return super.performOk();
    }
}

